function[x_cargo, x_motor, timestamp] = Motorstepping_Gillespie(kin1, kin2, kin3, DDB, dyn, mtype, kBT, stepsize, nruns, Test)

tmax = 50; % sec, simulation time
nmotor = length(mtype); % number of motors
x_cargo = {};
x_motor = {};
timestamp = {};

ExF = 0; % external force

parfor iirun = 1:nruns
    tt = 0;
    tp_record = tt;
    mstate = ones(nmotor, 1);
%     mDDB = DDB;
%     mKin1 = kin1;
%     mKin2 = kin2;
%     mKin3 = kin3;
    m_pos = zeros(1, nmotor);
    xm_record = m_pos;
    c_pos = 0;
    xc_record = c_pos;
    k0 = [zeros(1, 7);
        zeros(1, 3) kin1.katt zeros(1, 3);
        zeros(1, 3) kin2.katt zeros(1, 3);
        zeros(1, 3) kin3.katt zeros(1, 3);
        zeros(1, 3) DDB.katt zeros(1, 3);
        zeros(1, 3) dyn.katt zeros(1, 3);        
        zeros(1, 4) DDB.ksw(3, :)];

    while tt < tmax
        eventrates = k0(mstate, :);
        logatt = ~isnan(m_pos);
        natt = sum(double(logatt));
        att_pos = m_pos(logatt);
        att_type = mtype(logatt);

        fxs = zeros(1, nmotor);
        fxs(logatt) = MotorLoad(att_type, (att_pos*stepsize), c_pos, kin1, kin2, kin3, DDB, dyn); % calculate load on attached motors

        eventrates(logatt, :) = MotorRate(att_type, natt, fxs(logatt), kin1, kin2, kin3, DDB, dyn, kBT, Test); % calculate reaction rate for attached motor

        sum_rates = sum(eventrates, 2);
        tt = tt + exprnd(1/sum(sum_rates));
        act_motor = randsample(nmotor, 1, true, sum_rates); % events on one of motors

        if isnan(m_pos(act_motor)) % reattach
            m_pos(act_motor) = mean(att_pos);
            mstate(act_motor) = 1;
            c_pos = CargoPos(mtype(~isnan(m_pos)), (m_pos(~isnan(m_pos))*stepsize), ExF, kin1, kin2, kin3, DDB, dyn);
        else
            act_rates = eventrates(act_motor, :);
            evt_motor = randsample(7, 1, true, act_rates);

            if evt_motor == 1 % forward step
                mstate(act_motor) = 1;
                m_pos(act_motor) = m_pos(act_motor) + 1;
                c_pos = CargoPos(att_type, (m_pos(~isnan(m_pos))*stepsize), ExF, kin1, kin2, kin3, DDB, dyn);
            elseif evt_motor == 2 % backstep
                mstate(act_motor) = 1;
                m_pos(act_motor) = m_pos(act_motor) - 1;
                c_pos = CargoPos(att_type, (m_pos(~isnan(m_pos))*stepsize), ExF, kin1, kin2, kin3, DDB, dyn);
            elseif evt_motor == 3 % detach
                if sum(double(logatt)) > 1
                    mstate(act_motor) = mtype(act_motor) + 1; % specific motor reattach rate
                    m_pos(act_motor) = NaN;
                    c_pos = CargoPos(mtype(~isnan(m_pos)), (m_pos(~isnan(m_pos))*stepsize), ExF, kin1, kin2, kin3, DDB, dyn);
                else % detach when only one motor binding                    
                    break
                end
                % event 5~7 are for DDB switch mode
            elseif evt_motor == 5
            elseif evt_motor == 6
            elseif evt_motor == 7
            end
        end
        tp_record = [tp_record; tt];
        xm_record = [xm_record; (m_pos*stepsize)];
        xc_record = [xc_record, c_pos];
    end
    timestamp{iirun} = tp_record;
    x_motor{iirun} = xm_record;
    x_cargo{iirun} = xc_record;
end

